/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.feature;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.SmallFloat;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.feature.FeatureException;
import org.apache.solr.request.SolrQueryRequest;

public class FieldLengthFeature
extends Feature {
    private String field;
    private static final float[] NORM_TABLE = new float[256];

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    @Override
    public LinkedHashMap<String, Object> paramsToMap() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(1, 1.0f);
        params.put("field", this.field);
        return params;
    }

    @Override
    protected void validate() throws FeatureException {
        if (this.field == null || this.field.isEmpty()) {
            throw new FeatureException(((Object)((Object)this)).getClass().getSimpleName() + ": field must be provided");
        }
    }

    private final float decodeNorm(long norm) {
        return NORM_TABLE[(int)(norm & 0xFFL)];
    }

    public FieldLengthFeature(String name, Map<String, Object> params) {
        super(name, params);
    }

    @Override
    public Feature.FeatureWeight createWeight(IndexSearcher searcher, boolean needsScores, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) throws IOException {
        return new FieldLengthFeatureWeight(searcher, request, originalQuery, efi);
    }

    static {
        FieldLengthFeature.NORM_TABLE[0] = 0.0f;
        for (int i = 1; i < 256; ++i) {
            float norm = SmallFloat.byte315ToFloat((byte)((byte)i));
            FieldLengthFeature.NORM_TABLE[i] = 1.0f / (norm * norm);
        }
    }

    public class FieldLengthFeatureWeight
    extends Feature.FeatureWeight {
        public FieldLengthFeatureWeight(IndexSearcher searcher, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) {
            super(FieldLengthFeature.this, FieldLengthFeature.this, searcher, request, originalQuery, efi);
        }

        public float getValueForNormalization() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm, float boost) {
        }

        @Override
        public Feature.FeatureWeight.FeatureScorer scorer(LeafReaderContext context) throws IOException {
            NumericDocValues norms = context.reader().getNormValues(FieldLengthFeature.this.field);
            if (norms == null) {
                return new Feature.FeatureWeight.ValueFeatureScorer(this, this, 0.0f, DocIdSetIterator.all((int)Integer.MAX_VALUE));
            }
            return new FieldLengthFeatureScorer((Feature.FeatureWeight)this, norms);
        }

        public class FieldLengthFeatureScorer
        extends Feature.FeatureWeight.FeatureScorer {
            NumericDocValues norms;

            public FieldLengthFeatureScorer(Feature.FeatureWeight weight, NumericDocValues norms) throws IOException {
                super(FieldLengthFeatureWeight.this, weight, DocIdSetIterator.all((int)Integer.MAX_VALUE));
                this.norms = null;
                this.norms = norms;
                IndexableField idxF = FieldLengthFeatureWeight.this.searcher.doc(0).getField(FieldLengthFeature.this.field);
                if (idxF.fieldType().omitNorms()) {
                    throw new IOException("FieldLengthFeatures can't be used if omitNorms is enabled (field=" + FieldLengthFeature.this.field + ")");
                }
            }

            @Override
            public float score() throws IOException {
                long l = this.norms.get(this.itr.docID());
                float numTerms = FieldLengthFeature.this.decodeNorm(l);
                return numTerms;
            }
        }
    }
}

