/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uima.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.uima.processor.SolrUIMAConfiguration;
import org.apache.solr.uima.processor.UIMAToSolrMapper;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.JCasPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIMAUpdateRequestProcessor
extends UpdateRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SolrUIMAConfiguration solrUIMAConfiguration;
    private AnalysisEngine ae;
    private JCasPool pool;

    public UIMAUpdateRequestProcessor(UpdateRequestProcessor next, String coreName, SolrUIMAConfiguration config, AnalysisEngine ae, JCasPool pool) {
        super(next);
        this.ae = ae;
        this.pool = pool;
        this.solrUIMAConfiguration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        String text = null;
        try {
            String[] texts;
            SolrInputDocument solrInputDocument = cmd.getSolrInputDocument();
            for (String currentText : texts = this.getTextsToAnalyze(solrInputDocument)) {
                text = currentText;
                if (text == null || text.length() <= 0) continue;
                JCas jcas = this.pool.getJCas(0L);
                try {
                    this.processText(text, jcas);
                    UIMAToSolrMapper uimaToSolrMapper = new UIMAToSolrMapper(solrInputDocument, jcas);
                    Map<String, Map<String, SolrUIMAConfiguration.MapField>> typesAndFeaturesFieldsMap = this.solrUIMAConfiguration.getTypesFeaturesFieldsMapping();
                    for (Map.Entry<String, Map<String, SolrUIMAConfiguration.MapField>> entry : typesAndFeaturesFieldsMap.entrySet()) {
                        uimaToSolrMapper.map(entry.getKey(), entry.getValue());
                    }
                }
                finally {
                    this.pool.releaseJCas(jcas);
                }
            }
        }
        catch (Exception e) {
            String debugString;
            String optionalFieldInfo;
            SchemaField uniqueKeyField;
            String logField = this.solrUIMAConfiguration.getLogField();
            if (logField == null && (uniqueKeyField = cmd.getReq().getSchema().getUniqueKeyField()) != null) {
                logField = uniqueKeyField.getName();
            }
            String string = optionalFieldInfo = logField == null ? "." : ". " + logField + "=" + cmd.getSolrInputDocument().getField(logField).getValue() + ", ";
            if (text != null && text.length() > 0) {
                int len = Math.min(text.length(), 100);
                debugString = " text=\"" + text.substring(0, len) + "...\"";
            } else {
                debugString = " null text";
            }
            if (this.solrUIMAConfiguration.isIgnoreErrors()) {
                log.warn("skip the text processing due to {}", (Object)new StringBuilder().append(e.getLocalizedMessage()).append(optionalFieldInfo).append(debugString));
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "processing error " + e.getLocalizedMessage() + optionalFieldInfo + debugString, (Throwable)e);
        }
        super.processAdd(cmd);
    }

    private String[] getTextsToAnalyze(SolrInputDocument solrInputDocument) {
        String[] textVals;
        String[] fieldsToAnalyze = this.solrUIMAConfiguration.getFieldsToAnalyze();
        boolean merge = this.solrUIMAConfiguration.isFieldsMerging();
        if (merge) {
            StringBuilder unifiedText = new StringBuilder("");
            for (String aFieldsToAnalyze : fieldsToAnalyze) {
                Object[] Values;
                if (solrInputDocument.getFieldValues(aFieldsToAnalyze) == null) continue;
                for (Object Value : Values = solrInputDocument.getFieldValues(aFieldsToAnalyze).toArray()) {
                    if (unifiedText.length() > 0) {
                        unifiedText.append(' ');
                    }
                    unifiedText.append(Value.toString());
                }
            }
            textVals = new String[]{unifiedText.toString()};
        } else {
            textVals = new String[fieldsToAnalyze.length];
            for (int i = 0; i < fieldsToAnalyze.length; ++i) {
                Object[] Values;
                if (solrInputDocument.getFieldValues(fieldsToAnalyze[i]) == null) continue;
                for (Object Value : Values = solrInputDocument.getFieldValues(fieldsToAnalyze[i]).toArray()) {
                    int n = i;
                    textVals[n] = textVals[n] + Value.toString();
                }
            }
        }
        return textVals;
    }

    private void processText(String textFieldValue, JCas jcas) throws ResourceInitializationException, AnalysisEngineProcessException {
        if (log.isDebugEnabled()) {
            log.debug("Analyzing text");
        }
        jcas.setDocumentText(textFieldValue);
        this.ae.process(jcas);
        if (log.isDebugEnabled()) {
            log.debug("Text processing completed");
        }
    }

    public SolrUIMAConfiguration getConfiguration() {
        return this.solrUIMAConfiguration;
    }
}

